/*! \file tlk_sclk_api_version.h
**********************************************************************************
*Title:                         Discretix Secured Clock Toolkit header file
*
* Filename:                     tlk_sclk_api_version.h 
*
* Project, Target, subsystem:   Toolkit, Secured Clock
* 
* Created:                      10.09.2008
*
* Modified:                     10.09.2008
*
* \Author                       Ira Boguslavsky
*
* \Remarks
*           Copyright (C) 2008 by Discretix Technologies Ltd. All Rights reserved.
**********************************************************************************/
#ifndef _TLK_SCLK_API_VERSION_H_
#define  _TLK_SCLK_API_VERSION_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "DX_VOS_BaseTypes.h"

    /************************ Defines ******************************/

    /* the TLK_SCLK release version definitions */

#define TLK_SCLK_RELEASE_TYPE         'A'
#define TLK_SCLK_MAJOR_VERSION_NUM     1
#define TLK_SCLK_MINOR_VERSION_NUM     0
#define TLK_SCLK_SUB_VERSION_NUM       1
#define TLK_SCLK_INTERNAL_VERSION_NUM  0

    /************************ Enums ********************************/

    /************************ Typedefs  ****************************/

#define TLK_SCLK_COMPONENT_NAME_SIZE_IN_CHARS (9UL)

    /* @brief the version structure definition */
    typedef struct// todo raviv - move somewhere...
    {
        DxChar_t   componentName[TLK_SCLK_COMPONENT_NAME_SIZE_IN_CHARS];
        DxUint32_t typeVer;
        DxUint32_t majorVer;
        DxUint32_t minorVer;
        DxUint32_t subVer;
        DxUint32_t internalVer;   
    }TLK_SCLK_ComponentVersion_t;

    typedef struct
    {
        TLK_SCLK_ComponentVersion_t tlk_sclk;
    }TLK_SCLK_Version_t;


    /************************ Public Functions **********************/
    /*TLK_SCLK_VersionGet*/
    /*!
    \brief    This function returns the TLK_SCLK version.

    @param[in] version_ptr - a pointer to the version structure.

    The release version number is handled by the following:

    D/B/R X1.X2.X3.X4

    The first letter defines the maturity of the release : 

    D  development , an internal release that passed maximim the unit tests.

    B  beta release , a release that usually passes the ATP by the QA.

    R  a formal release , passed all of the QA tests.


    X1  primary version  on our case it will be set as 6 ( when this version is updated all 
    of the lower ones X2,X3,X4 are reset to 0 ).

    X2  minor version  this number should be updated if a major feature is added or the API 
    interface has changed. ( when this version is updated X3,X4 are reset ).

    X3  sub versoion  on each new release passed to the QA this number should be incremented ( X4 is reset )

    X4  internal RD version , on each commit this number should be incremented , when the release is
    passed to the QA its reset and X3 is incremented. On each release send to customer this value should be 0.

    Note that releases passed to the customer have only 3 digits on the release R X1.X2.X3

    **/

    DxError_t TLK_SCLK_VersionGet(TLK_SCLK_Version_t *version_ptr);


#ifdef __cplusplus
}
#endif /*extern "C"*/

#endif /*_TLK_SCLK_API_VERSION_H_*/
